define([
    'underscore',
    'marionette',
    'text!modules/new-appointment-request/views/direct/pac-team/template.html',
    'modules/new-appointment-request/views/direct/pac-team/modal',
], function(
    _,
    Marionette,
    providersTemplate,
    PactTeamModalView
) {
    'use strict';

    return Marionette.View.extend({
        template: providersTemplate,

        className: 'pacTeam',

        events: {'click .pact-team-link': 'viewPactTeamModal'},

        initialize: function() {
            this.primaryProviderList = this.getPrimaryProviderString();
        },

        getPrimaryProviderString: function() {
            var providers = this.options.team.where({possiblePrimary: 'Y'});

            var staff = _.map(providers, function(model) {
                return model.get('staffName');
            });

            return staff.join('; ');
        },

        templateContext: function() {
            return {
                primaryProviderList: this.primaryProviderList,
                facilityName: this.model.getFacilityName(),
                facilityId: this.model.getInstitutionCode(),
            };
        },

        viewPactTeamModal: function(e) {
            var modal;
            e.preventDefault();

            modal = new PactTeamModalView({
                elAfterClose: e.currentTarget,
                team: this.options.team,
                primaryProviderList: this.primaryProviderList,

            });
            modal.openPopup();
        },
    });
});
